% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{use_NOIseq}
\alias{use_NOIseq}
\title{Differential expression method for NOISeq}
\usage{
use_NOIseq(se, colData_id, control, treatment, rank = FALSE, ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{colData_id}{One of the columns of colData(se). It should be factors of more than one value.}

\item{control}{Base level and one of the factor values of \code{colData(se)[[colData_id]]}}

\item{treatment}{one of the factor values of \code{colData(se)[[colData_id]]}}

\item{rank}{Logical value default FALSE. If true the result will have an
additional column named "rank" which is ordered by ´prob´ values returned by
function NOISeq::\code{\link{noiseqbio}}.}

\item{...}{other arguments to be passed to main function NOISeq::\code{\link{noiseqbio}}.
The 'input' and 'factor' argument should not be used.}
}
\value{
A data.frame object from the results of NOISeq::noiseqbio(). For details check
the documentation of ´NOISeq´
}
\description{
This is a wrapper function of NOISeq::\code{\link{noiseqbio}} whose input class is ´eSet´
and output class is \code{Output} which are not widely used. We can use as(se, "ExpressionSet")
to get an eSet easily but then it will be hard to refer the treatment and control.
The order of factors influence the log fold change sign. To keep it comparable
to other methods the \code{NOISeq::readData()} is used internally.
}
\examples{

se <- readRDS(system.file("extdata",
        "rat_vole_mouseSE_salmon.rds",
        package = "broadSeq"))

# To reduce runtime
se <- se[rowData(se)$chromosome_name == 2,colData(se)$species == "Mouse"]

result_Noiseq <-
    use_NOIseq(se = se,
           colData_id = "stage", control = "Bud", treatment = "Cap",
           rank = TRUE,
           r = 10) # r is an argument of NOISeq::noiseqbio
}
