% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{use_DELocal}
\alias{use_DELocal}
\title{To use SummarizedExperiment with package DELocal}
\usage{
use_DELocal(se, colData_id, control, treatment, rank = FALSE, ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{colData_id}{One of the columns of colData(se). It should be factors of
more than one value.}

\item{control}{Base level and one of the factor values of \code{colData(se)[[colData_id]]}}

\item{treatment}{one of the factor values of \code{colData(se)[[colData_id]]}}

\item{rank}{Logical value default FALSE. If true the result will have an
additional column named "rank" and the results are ranked on "relative.logFC"}

\item{...}{other arguments to be passed to main function DELocal::\code{\link{DELocal}}.}
}
\value{
a data.frame from DELocal
}
\description{
A wrapper function of DELocal where input is an object of \code{\link{SummarizedExperiment}}
}
\examples{

se <- readRDS(system.file("extdata",
        "rat_vole_mouseSE_salmon.rds",
        package = "broadSeq"))

# To reduce runtime
se <- se[rowData(se)$chromosome_name == 2,colData(se)$species == "Mouse"]

result <-
    use_DELocal(se = se,
           colData_id = "stage", control = "Bud", treatment = "Cap",
           rank = TRUE)
}
