% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{transformDESeq2}
\alias{transformDESeq2}
\title{Transform SummarizedExperiment with DESeq2 package}
\usage{
transformDESeq2(se, method = "vst", ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{method}{"vst", "normTransform" or "rlog" to choose either of DESeq2::\code{\link{varianceStabilizingTransformation}}
DESeq2::\code{\link{normTransform}} and DESeq2::\code{\link{rlog}} function.
default is "vst"}

\item{...}{arguments passed to \code{\link{varianceStabilizingTransformation}}
\code{\link{normTransform}} and \code{\link{rlog}}}
}
\value{
Object of \code{\link{SummarizedExperiment}} class where a new assay
is added to the input object.
}
\description{
To use SummarizedExperiment with DESeq2, this function makes sure that 'counts'
assay should be the first in assays list and the mode is integer.
}
\examples{
 se <- readRDS(system.file("extdata",
        "rat_vole_mouseSE_salmon.rds",
        package = "broadSeq"))

se <- broadSeq::transformDESeq2(se,method = "vst"  )
# The transformed values are added with the assay name "vst"
SummarizedExperiment::assayNames(se)
}
