% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sampleAssay_plot}
\alias{sampleAssay_plot}
\title{Useful to visualize distribution of assay values for each sample. Plots 'boxplot'
of any assay for each sample. Aesthetic can be added from colData.}
\usage{
sampleAssay_plot(se, assayName = "counts", ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{assayName}{One of the values from SummarizedExperiment::assayNames(se)}

\item{...}{other arguments to be passed to ggpubr::\code{\link{ggboxplot}}}
}
\value{
ggplot object
}
\description{
Useful to visualize distribution of assay values for each sample. Plots 'boxplot'
of any assay for each sample. Aesthetic can be added from colData.
}
\examples{
se <- readRDS(system.file("extdata","rat_vole_mouseSE_salmon.rds", package = "broadSeq"))

sampleAssay_plot(se, assayName = "counts",
fill="stage", # stage is a column name of colData(se)
yscale="log2")

se <- broadSeq::normalizeEdgerCPM(se ,method = "none",cpm.log = TRUE )

sampleAssay_plot(se, assayName = "logCPM", fill="stage")
}
