% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringVisualization.R
\name{plot_MDS}
\alias{plot_MDS}
\title{Classical multidimensional scaling}
\usage{
plot_MDS(se, scaledAssay = "vst", ntop = 500L, features = NULL, ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{scaledAssay}{an scaled assay name from SummarizedExperiment::assayNames(se)}

\item{ntop}{number of most-variable genes to select. Igored if "features" is specified.}

\item{features}{character vector features/genes to be used to measure distance between the samples}

\item{...}{other arguments like color or shape whose values should be similar
to colData columns names passed to ggpubr::\code{\link{ggscatter}}}
}
\value{
ggplot object
}
\description{
Classical multidimensional scaling is based on measuring the distance between the samples.
}
\examples{
se <- readRDS(system.file("extdata","rat_vole_mouseSE_salmon.rds", package = "broadSeq"))

se <- broadSeq::transformDESeq2(se,method = "vst"  )

broadSeq::plot_MDS(se, scaledAssay = "vst", ntop=500,
                    color = "species", shape = "stage",
                    ellipse=TRUE, legend = "bottom")
}
