% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalizeEdgerCPM}
\alias{normalizeEdgerCPM}
\title{Use of edgeR package to normalize count data}
\usage{
normalizeEdgerCPM(se, method = "TMM", cpm.log = TRUE, ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{method}{value for edgeR::\code{\link{normLibSizes}} function. default "TMM"}

\item{cpm.log}{value for edgeR::\code{\link{cpm}} function. default TRUE}

\item{...}{passed to normLibSizes function}
}
\value{
Object of \code{\link{SummarizedExperiment}} class where a new assay
is added to the input object.
}
\description{
Use of edgeR package to normalize count data
}
\examples{
se <- readRDS(system.file("extdata",
        "rat_vole_mouseSE_salmon.rds",
        package = "broadSeq"))

se <- broadSeq::normalizeEdgerCPM(se , method = "TMM", cpm.log = FALSE )
# The normalized values are added with the assay name "TMM"
SummarizedExperiment::assayNames(se)
}
