% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{genes_plot}
\alias{genes_plot}
\alias{assay_plot}
\title{Expression of multiple genes/features from a single assay as boxplot (or added dotplot)}
\usage{
genes_plot(se, features, assayName = "counts", facet.by = "feature", x, ...)

assay_plot(se, feature, assayNames = c("counts"), x, ...)
}
\arguments{
\item{se}{Object of \code{\link{SummarizedExperiment}} class}

\item{features}{a character vector of rownames or named list of character vectors
where name is one of the colnames of rowdata.}

\item{assayName}{One of the values from SummarizedExperiment::assayNames(se);
default is "counts" assay}

\item{facet.by}{must be one of the column names of rowData(se). default
"feature" which is equivalent to rownames of rowData}

\item{x}{a column name of colData which will be used in x-axis}

\item{...}{other arguments to be passed to ggpubr::\code{\link{ggboxplot}}}

\item{feature}{a character vector of rownames or named list of character vectors
where name is one of the column of rowdata.}

\item{assayNames}{names from SummarizedExperiment::assayNames(se); default
value is "counts"}
}
\value{
ggplot object

return an object of class ggarrange, which is a ggplot or a list of ggplot.
}
\description{
Expression of multiple genes/features from a single assay as boxplot (or added dotplot)

Boxplot of a single gene/feature from multiple assays
}
\examples{
se <- readRDS(system.file("extdata", "rat_vole_mouseSE_salmon.rds",
    package = "broadSeq"))
# The normalized values are added with the assay name "logCPM"
se <- broadSeq::normalizeEdgerCPM(se ,method = "none",cpm.log = TRUE )

broadSeq::genes_plot(se,
                     features = list(mouse_gene_id = c("ENSMUSG00000022510" ,
                                                        "ENSMUSG00000027985")),
                     facet.by = "symbol", # column of rowData
                     x = "stage",  fill="stage")

broadSeq::genes_plot(se,
                     features = list(symbol=c("Shh","Edar") ),
                     facet.by = "symbol", # column of rowData
                     x = "stage",  fill="stage")

broadSeq::assay_plot(se, feature = c("Shh"),
                    assays =  c("counts","logCPM"),
                    x = "stage", fill="stage", add="dotplot", palette = "npg")
}
