% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{combinedEnrichment}
\alias{combinedEnrichment}
\title{Provides GO gene set enrichment and over-representation analysis}
\usage{
combinedEnrichment(
  DEG_table,
  geneCol = "ID",
  logCol = "logFoldChange",
  OrgDB = "org.Hs.eg.db",
  keyType,
  universe,
  ont = "BP",
  logfoldCut = 1,
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.05
)
}
\arguments{
\item{DEG_table}{A data.frame atleast with two columns.}

\item{geneCol}{The column name of DEG_table which provides gene ids and should
be compatible with keytype parameter.}

\item{logCol}{The column name of DEG_table which provides logfold(numeric) values to
create a order ranked geneList for gseGO funtion.}

\item{OrgDB}{OrgDb; passed to clusterProfiler functions}

\item{keyType}{keytype of input gene(geneCol). One of the keytypes(OrgDB); passed to clusterProfiler functions}

\item{universe}{background genes; passed to clusterProfiler::enrichGO.}

\item{ont}{one of "BP", "MF", and "CC" subontologies, or "ALL" for all three.; passed to clusterProfiler functions}

\item{logfoldCut}{to filter genes based on parameter logCol}

\item{pvalueCutoff}{; passed to clusterProfiler functions}

\item{qvalueCutoff}{; passed to clusterProfiler functions}
}
\value{
a named list of three data.frames which are output of gseGO("gseResult")
and enrichGO ("oraUP" and "oraDOWN").
}
\description{
This wrapper function combines clusterProfiler::gseGO and
clusterProfiler::enrichGO. The input type of thes two methods are different;
order ranked geneList and a vector of entrez gene id. Here combinedEnrichment
function internally generates these two data types from user defined DEG_table
(differentially expresssed genes).
}
