% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syncReads.R
\name{synchronizeReadDir}
\alias{synchronizeReadDir}
\title{Synchronize Strand-seq read directionality}
\usage{
synchronizeReadDir(files2sync, collapseWidth = 5e+06)
}
\arguments{
\item{files2sync}{A list of files that contains \code{\link{BreakPoint}} objects.}

\item{collapseWidth}{A segment size to be collapsed with neighbouring segments.}
}
\value{
A \code{\link{GRanges-class}} object that reads synchronized by directionality.
}
\description{
This function aims to synchronize strand directionality of reads that fall into WW and CC regions.
}
\examples{
## Get some files that you want to load
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
files2sync <- list.files(exampleFolder, full.names=TRUE)[1]
synchronizeReadDir(files2sync=files2sync)

}
\author{
David Porubsky
}
