% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenotypeBreaks.R
\name{genotyping}
\alias{genotyping}
\alias{GenotypeBreaks}
\title{Set of functions to genotype regions in between localized breakpoints}
\usage{
GenotypeBreaks(
  breaks,
  fragments,
  background = 0.05,
  minReads = 10,
  genoT = "fisher"
)
}
\arguments{
\item{breaks}{A \code{\link{GRanges-class}} object with breakpoint coordinates.}

\item{fragments}{A \code{\link{GRanges-class}} object with read fragments.}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}

\item{minReads}{The minimal number of reads between two breaks required for genotyping.}

\item{genoT}{A method ('fisher' or 'binom') to genotype regions defined by a set of breakpoints.}
}
\value{
A \code{\link{GRanges-class}} object with genotyped breakpoint coordinates.
}
\description{
Each defined region is given one of the three states ('ww', 'cc' or 'wc')
Consecutive regions with the same state are collapsed
}
\details{
Function \code{GenotypeBreaks} exports states of each region defined by breakpoints.
Function \code{genotype.fisher} assigns states to each region based on expected counts of Watson and Crick reads.
Function \code{genotype.binom} assigns states to each region based on expected counts of Watson and Crick reads.
}
\section{Functions}{
\itemize{
\item \code{GenotypeBreaks()}: Genotypes breakpoint defined regions.

}}
\examples{
## Get an example file 
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFile <- list.files(exampleFolder, full.names=TRUE)[1]
## Load the file 
breakpoint.objects <- get(load(exampleFile))
## Genotype regions between breakpoints
gbreaks <- GenotypeBreaks(breaks=breakpoint.objects$breaks, fragments=breakpoint.objects$fragments)

}
\author{
David Porubsky, Ashley Sanders, Aaron Taudt
}
