% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidenceInterval.R
\name{confidenceInterval}
\alias{confidenceInterval}
\title{Estimate confidence intervals for breakpoints}
\usage{
confidenceInterval(breaks, fragments, background = 0.05, conf = 0.99)
}
\arguments{
\item{breaks}{Genotyped breakpoints as outputted from function \code{\link{GenotypeBreaks}}.}

\item{fragments}{Read fragments from function \code{\link{readBamFileAsGRanges}}.}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}

\item{conf}{Desired confidence interval of localized breakpoints.}
}
\value{
A \code{\link{GRanges-class}} object of breakpoint ranges for a given confidence interval in \code{conf}.
}
\description{
Estimate confidence intervals for breakpoints by going outwards from the breakpoint read by read, and multiplying the probability that the read doesn't belong to the assigned segment.
}
\examples{
\dontrun{ 
## Get an example file 
exampleFolder <- system.file("extdata", "example_results", package="breakpointRdata")
exampleFile <- list.files(exampleFolder, full.names=TRUE)[1]
## Load the file 
breakpoint.objects <- get(load(exampleFile))
## Calculate confidence intervals of genotyped breakpoints
confint <- confidenceInterval(breaks=breakpoint.objects$breaks, fragments=breakpoint.objects$fragments, background=0.02)}

}
\author{
Aaron Taudt, David Porubsky
}
