% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{simBoolGtn}
\alias{simBoolGtn}
\title{Sample random network and simulate data}
\usage{
simBoolGtn(
  Sgenes = 10,
  maxEdges = 25,
  stimGenes = 2,
  layer = 1,
  frac = 0.1,
  maxInDeg = 2,
  dag = TRUE,
  maxSize = 2,
  maxStim = 2,
  maxInhibit = 1,
  Egenes = 10,
  flip = 0.33,
  reps = 1,
  keepsif = FALSE,
  negation = 0.25,
  allstim = FALSE,
  and = 0.25,
  positive = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{Sgenes}{number of S-genes}

\item{maxEdges}{number of maximum edges (upper limit) in the DAG}

\item{stimGenes}{number of stimulated S-genes}

\item{layer}{scaling factor for the sampling of next Sgene layerof the 
prior. high (5-10) mean more depth and low (0-2) means more breadth}

\item{frac}{fraction of hyper-edges in the ground truth (GTN)}

\item{maxInDeg}{maximum number of incoming hyper-edges}

\item{dag}{if TRUE, graph will be acyclic}

\item{maxSize}{maximum number of S-genes in a hyper-edge}

\item{maxStim}{maximum of stimulated S-genes in an experiment (=data samples)}

\item{maxInhibit}{maximum number of inhibited S-genes in
an experiment (=data samples)}

\item{Egenes}{number of E-genes per S-gene, e.g. 10 S-genes and 10
E-genes will return 100 E-genes overall}

\item{flip}{fraction of inhibited E-genes}

\item{reps}{number of replicates}

\item{keepsif}{if TRUE does not delete sif file, which encodes
the prior network}

\item{negation}{sample probability for negative or NOT edges}

\item{allstim}{full network in which all S-genes are also stimulated}

\item{and}{probability for AND-gates in the GTN}

\item{positive}{if TRUE, sets all stimulation edges to activation, else
samples inhibitory edges by 'negation' probability}

\item{verbose}{TRUE for verbose output}
}
\value{
list with the corresponding prior graph, ground truth network and
data
}
\description{
Draws a random prior network, samples a ground truth from the full boolean
extension and generates data
}
\examples{
sim <- simBoolGtn()
plot(sim)
}
\author{
Martin Pirkl
}
