\name{cgEx}
\alias{cgEx}
\title{
  Sample chr22 Data
}
\description{
  This is a sample ContactGroup object representing observations on
  chr22 from 3 1k Genomes trios' lymphoblastoid cell lines (LCL). \code{colData(cgEx)} gives the cell
  line name (\code{CellLine}), the ethnicity of the individual
  (\code{Population}), the family (\code{Family}), the gender
  (\code{Gender}), the relationship of the individuals within a trio
  (\code{Role}), the replicate number (\code{Tech}) and each sample's
  batch (\code{Batch}).

  These data were generated by the dilution Hi-C method using HindIII
  (Lieberman-Aiden et al.).  Hi-C contact matrices were generated by
  tiling the genome into 40kb bins and counting the number of
  interactions between bins.

  These data have undergone no preprocessing.
}
\format{
  The data is an object of class \code{ContactGroup}.
}
\source{
  Raw data are available from the 4D nucleome data portal
  (\url{https://data.4dnucleome.org}) under accessions 4DNESYUYFD6H,
  4DNESVKLYDOH, 4DNESHGL976U, 4DNESJ1VX52C, 4DNESI2UKI7P, 4DNESTAPSPUC,
  4DNES4GSP9S4, 4DNESJIYRA44, 4DNESE3ICNE1.
}
\references{
Lieberman-Aiden, E, et al. \emph{Comprehensive mapping of long-range
  interactions reveals folding principles of the human genome}. Science
  2009, 326:289-293.  \doi{10.1126/science.1181369}
}
\seealso{
  \code{\link{ContactGroup}}
}
\keyword{datasets}

