% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping_result_plotting.R
\name{plot_mapping_result_heatmap}
\alias{plot_mapping_result_heatmap}
\title{Plot a mapping result heatmap}
\usage{
plot_mapping_result_heatmap(
  mapping_result_list,
  heatmap_fill_scale = ggplot2::scale_fill_gradientn(colors = c("blue", "white", "red"),
    limits = c(-1, 1)),
  annotate_confidence = TRUE,
  annotate_correlation = FALSE,
  bin_order = NULL,
  text_background = FALSE
)
}
\arguments{
\item{mapping_result_list}{A list of \link{MappingResult} objects to include
in the heatmap.}

\item{heatmap_fill_scale}{The ggplot2 compatible fill gradient scale to
apply to the heatmap.}

\item{annotate_confidence}{Boolan. Whether to annotate the heatmap with
significant results or not, defaults to TRUE.}

\item{annotate_correlation}{Boolean. Whether to annotate the heatmap with
the correlation of bin to each bulk sample. Defaults to FALSE.}

\item{bin_order}{Vector of integers. A vector of the bin ids in which to
plot the pseudotime bins along the x-axis.}

\item{text_background}{Boolean. Whether to show background on labels or
not. Has no effect if no annotations are enabled.}
}
\value{
A \link[ggplot2:ggplot2-package]{ggplot2::ggplot2} heatmap showing the
correlations of each mapping result across
every pseudotime bin.
}
\description{
Plots Spearman's Rho as the fill colour, and adds * if the \link{MappingResult}
was confidently assigned.
}
\examples{
counts_matrix <- matrix(
    c(seq_len(120) / 10, seq_len(120) / 5),
    ncol = 48, nrow = 5
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- seq_len(48)
rownames(sce) <- as.character(seq_len(5))
sce$cell_type <- c(rep("celltype_1", 24), rep("celltype_2", 24))

sce$pseudotime <- seq_len(48) - 1
blase_data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 4)
genes(blase_data) <- as.character(seq_len(5))

bulk_counts <- matrix(seq_len(15) * 10, ncol = 3, nrow = 5)
colnames(bulk_counts) <- c("A", "B", "C")
rownames(bulk_counts) <- as.character(seq_len(5))

# Map to bin
result <- map_best_bin(blase_data, "B", bulk_counts)
result

# Map all bulks to bin
results <- map_all_best_bins(blase_data, bulk_counts)

# Plot Heatmap
plot_mapping_result_heatmap(list(result))

# Plot Correlation
plot_mapping_result_corr(result)

# Plot populations
sce <- assign_pseudotime_bins(
    sce,
    pseudotime_slot = "pseudotime", n_bins = 4
)
plot_bin_population(sce, best_bin(result), group_by_slot = "cell_type")

# Getters
bulk_name(result)
best_bin(result)
best_correlation(result)
top_2_distance(result)
confident_mapping(result)
mapping_history(result)
bootstrap_iterations(result)
}
\concept{mapping_plots}
