% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{get_bins_as_bulk}
\alias{get_bins_as_bulk}
\title{Get a pseudobulk of bins with at least 2 replicates}
\usage{
get_bins_as_bulk(
  pseudotime_sce,
  min_cells_for_bulk = 50,
  replicate_slot = "replicate"
)
}
\arguments{
\item{pseudotime_sce}{The \link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment::SingleCellExperiment}
object to get the bins from}

\item{min_cells_for_bulk}{Integer. The minimum cells to look for per
replicate and bin.}

\item{replicate_slot}{String. The name of the matadata column in the
Single Cell Experiment that contains replicate information}
}
\value{
A dataframe containing the pseudobulked counts matrix.
}
\description{
This function will try to create a pseudobulked count matrix for the bins.
When a replicate has too few cells, it is discounted. If only one exists,
then we sample from it twice to create the pseudobulks.
}
\examples{
library(SingleCellExperiment, quietly = TRUE)
library(blase)
counts <- matrix(rpois(1000, lambda = 10), ncol = 100, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts, counts = counts / 2)
)
sce$pseudotime <- seq_len(100) - 1
colnames(sce) <- seq_len(100)
rownames(sce) <- as.character(seq_len(10))
sce <- assign_pseudotime_bins(sce,
    n_bins = 5,
    pseudotime_slot = "pseudotime", split_by = "cells"
)
sce$replicate <- rep(c(1, 2), 50)
result <- get_bins_as_bulk(
    sce,
    min_cells_for_bulk = 1,
    replicate_slot = "replicate"
)
result
}
\concept{util}
