% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blase_data_class.R
\name{genes<-}
\alias{genes<-}
\alias{genes<-,BlaseData-method}
\title{Set genes of a BLASE Data object.}
\usage{
genes(x) <- value

\S4method{genes}{BlaseData}(x) <- value
}
\arguments{
\item{x}{a \link{BlaseData} object}

\item{value}{Vector of strings. The new value for genes slot}
}
\value{
Nothing
}
\description{
Set genes of a BLASE Data object.
}
\examples{
counts <- matrix(rpois(100, lambda = 10), ncol = 10, nrow = 10)
sce <- SingleCellExperiment::SingleCellExperiment(
    assays = list(normcounts = counts)
)
sce$pseudotime <- seq_len(10) - 1
data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 3)
genes(data) <- as.character(seq_len(10))

genes(data)
}
\concept{blase-object}
