% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{evaluate_parameters}
\alias{evaluate_parameters}
\title{Evaluate n_bins and n_genes for bin mapping}
\usage{
evaluate_parameters(
  blase_data,
  bootstrap_iterations = 200,
  BPPARAM = BiocParallel::SerialParam(),
  make_plot = FALSE,
  plot_columns = 4
)
}
\arguments{
\item{blase_data}{The \link{BlaseData} object to use.}

\item{bootstrap_iterations}{Integer. Iterations for
bootstrapping when calculating confident mappings.}

\item{BPPARAM}{The \link[BiocParallel:BiocParallelParam-class]{BiocParallel::BiocParallelParam} configuration.
Defaults to \link[BiocParallel:SerialParam-class]{BiocParallel::SerialParam}}

\item{make_plot}{Boolean. Whether or not to render the plot
showing the correlations for each pseudobulk bin when we try
to map the given bin.}

\item{plot_columns}{Integer. How many columns to use in the plot.}
}
\value{
A vector of length 3:
\itemize{
\item "worst top 2 distance" decimal containing the lowest difference between the
absolute values of the top 2 most correlated bins for each bin.
Higher is better for differentiating.
\item "mean top 2 distance" decimal containing the mean top 2 distance across the
entire set of genes and bins. Higher is better for differentiation,
but it should matter less than the worst value.
\item "confident_mapping_pct" decimal from 0-1. The percent of
mappings for this setup which were annotated as confident by BLASE.
}
}
\description{
Will use the n_bins and n_genes implied by the \code{sce} and
\code{pseudotime_bins_top_n_genes_df} parameters and return quality metrics and
an optional chart.
}
\examples{
ncells <- 70
ngenes <- 100
counts_matrix <- matrix(
    c(seq_len(3500) / 10, seq_len(3500) / 5),
    ncol = ncells,
    nrow = ngenes
)
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(
    normcounts = counts_matrix, logcounts = log(counts_matrix)
))
colnames(sce) <- seq_len(ncells)
rownames(sce) <- as.character(seq_len(ngenes))
sce$cell_type <- c(
    rep("celltype_1", ncells / 2),
    rep("celltype_2", ncells / 2)
)

sce$pseudotime <- seq_len(ncells) - 1
genelist <- as.character(seq_len(ngenes))

# Evaluating created BlaseData
blase_data <- as.BlaseData(sce, pseudotime_slot = "pseudotime", n_bins = 10)
genes(blase_data) <- genelist[1:20]

# Check convexity of parameters
evaluate_parameters(blase_data, make_plot = TRUE)
}
\concept{tuning}
