% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{count_outliers}
\alias{count_outliers}
\title{Count up the outlier information for each of the groups you have made.
If aggregating then you will have to turn the parameter on, but you still
    input the outliertable. Aggregate will count the total number of
    outliers AND nonoutliers in its operation, so it needs the original
    outlier table made by the <make_outlier_table> function.}
\usage{
count_outliers(groupings, outliertab,
    aggregate_features = FALSE, feature_delineator = "\\\\.")
}
\arguments{
\item{groupings}{table generated by the comparison_groupings function}

\item{outliertab}{outlier table generated by make_outlier_table}

\item{aggregate_features}{DEFAULT: FALSE; Toggle the Aggregate feature, which
will aggregate features in your table based on the given delineator.
Aggregation will output counts for the TOTAL number of outliers and non-
outliers across ALL sites you aggregate across.}

\item{feature_delineator}{DEFAULT: <"\\.">; What character delineates the
separation between primary and secondary features. NOTE: to use proper
R syntax with escape characters if necessary
Ex) Protein1.Phosphosite1 uses "\\." to aggregate on Protein1}
}
\value{
the tabulated information of outliers per group
}
\description{
Count up the outlier information for each of the groups you have made.
If aggregating then you will have to turn the parameter on, but you still
    input the outliertable. Aggregate will count the total number of
    outliers AND nonoutliers in its operation, so it needs the original
    outlier table made by the <make_outlier_table> function.
}
\examples{

data("sample_phosphodata")
reftable_function_out <- make_outlier_table(sample_phosphodata[1:1000,])
outliertab <- reftable_function_out$outliertab

data("sample_annotationdata")
groupings <- comparison_groupings(sample_annotationdata)

count_outliers_out <- count_outliers(groupings, outliertab,
    aggregate_features = FALSE)
grouptablist <- count_outliers_out$grouptablist
fractiontab <- count_outliers_out$fractiontab
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
