% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkBiscuitBED.R
\name{checkBiscuitBED}
\alias{checkBiscuitBED}
\title{Inspect Biscuit VCF and BED files}
\usage{
checkBiscuitBED(
  BEDfile,
  VCFfile,
  merged,
  sampleNames = NULL,
  chunkSize = 5e+07,
  hdf5 = FALSE,
  sparse = TRUE,
  how = c("data.table", "readr"),
  chr = NULL
)
}
\arguments{
\item{BEDfile}{A BED-like file - must be compressed and tabix'ed}

\item{VCFfile}{A VCF file - must be compressed and tabix'ed. Only the
header information is needed.}

\item{merged}{Is this merged CpG data?}

\item{sampleNames}{Names of samples - NULL: create names, vector: assign
names, data.frame: make pData (DEFAULT: NULL)}

\item{chunkSize}{For files longer than \code{yieldSize} number of lines long,
chunk the file (DEFAULT: 5e7)}

\item{hdf5}{Use HDF5 arrays for backing the data? Using HDF5-backed
arrays stores the data in a HDF5 file on disk, rather
than loading entire object into memory. This allows
for analyses to be done on memory-limited systems at
the small cost of slightly reduced return times.
(DEFAULT: FALSE)}

\item{sparse}{Use sparse Matrix objects for the data? If TRUE, use a
Matrix object for sparse matrices (matrices with many
zeroes in them) (DEFAULT: TRUE)}

\item{how}{How to load the data - "data.table" or "readr"?
(DEFAULT: data.table)}

\item{chr}{Load a specific chromosome to rbind() later?
(DEFAULT: NULL)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{        Parameters to be supplied to makeBSseq
}\if{html}{\out{</div>}}
}
\description{
A BED checker for Biscuit CpG/CpH output (BED-like format with 2 or 3
columns per sample). By default, files with more than 50 million loci will
be processed iteratively, since data.table tends to run into problems with
gzipped joint CpH files.
}
\details{
Input BED and VCF files must be tabix'ed. No exceptions!
}
\examples{

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  params <- checkBiscuitBED(BEDfile = orig_bed, VCFfile = orig_vcf,
                            merged = FALSE)

}
\seealso{
readBiscuit
}
