% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biscuitMetadata.R
\name{biscuitMetadata}
\alias{biscuitMetadata}
\alias{getBiscuitMetadata}
\title{Biscuit metadata from VCF header}
\usage{
biscuitMetadata(bsseq = NULL, VCF = NULL)

getBiscuitMetadata(bsseq = NULL, VCF = NULL)
}
\arguments{
\item{bsseq}{A bsseq object with a vcfHeader element (DEFAULT: NULL)}

\item{VCF}{A tabix'ed VCF file (can just be the header information)
from which the bsseq vcfHeader element is derived
(DEFAULT: NULL)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{  Information regarding the Biscuit run
}\if{html}{\out{</div>}}
}
\description{
Returns metadata from a Biscuit run using either a supplied VCF file or
the vcfHeader metadata element from the bsseq object
}
\section{Functions}{
\itemize{
\item \code{getBiscuitMetadata()}: Alias for biscuitMetadata

}}
\examples{

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  bisc <- readBiscuit(BEDfile = orig_bed, VCFfile = orig_vcf,
                      merged = FALSE)

  meta <- biscuitMetadata(bisc)
  
}
