% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRBSeq.R
\name{RRBSeq}
\alias{RRBSeq}
\title{(e)RRBS settings for dmrseq}
\usage{
RRBSeq(bsseq, testCovariate, cutoff = 0.2, bpSpan = 750, ...)
}
\arguments{
\item{bsseq}{A bsseq object}

\item{testCovariate}{The pData column to test on}

\item{cutoff}{The minimum CpG-wise difference to use (DEFAULT: 0.2)}

\item{bpSpan}{Span of smoother AND max gap in DMR CpGs (DEFAULT: 750)}

\item{...}{Other arguments to pass along to dmrseq}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{          A GRanges object (same as from dmrseq)
}\if{html}{\out{</div>}}
}
\description{
(e)RRBS settings for dmrseq
}
\examples{

  data(BS.chr21, package="dmrseq")
  dat <- BS.chr21

  rrbs <- RRBSeq(dat[1:500, ], "Rep", cutoff = 0.05, BPPARAM=BiocParallel::SerialParam())

}
