% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcts_biodb.R
\name{df2str}
\alias{df2str}
\title{Convert a data.frame into a string.}
\usage{
df2str(x, rowCut = 5, colCut = 5)
}
\arguments{
\item{x}{The data frame object.}

\item{rowCut}{The maximum of rows to print.}

\item{colCut}{The maximum of columns to print.}
}
\value{
A string containing the data frame representation (or part of it).
}
\description{
Prints a data frame (partially if too big) into a string.
}
\examples{
# Converts the first 5 rows and first 6 columns of a data frame into a
# string:
x <- data.frame(matrix(1:160, nrow=10, byrow=TRUE))
s <- df2str(x, rowCut=5, colCut=6)

}
