% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocthis_example_pkg.R
\name{biocthis_example_pkg}
\alias{biocthis_example_pkg}
\title{Create a temporary example package}
\usage{
biocthis_example_pkg(name = "biocthisexample", use_git = FALSE)
}
\arguments{
\item{name}{A \code{character(1)} with the name of the example package.}

\item{use_git}{A \code{logical(1)} indicating whether to set up \code{git} through
\code{usethis::use_git()} on the temporary example package.}
}
\value{
A \code{character(1)} with the path to a temporary example package to use
in the examples of the \code{biocthis} functions.
}
\description{
This function creates a temporary example package. It is used by the
functions in \code{biocthis} to illustrate the functionality of the package
without exposing users to internals of \code{usethis} that users do not need
to use under typical working conditions.
}
\details{
This function creates a package under \code{tempdir()} with the \code{name} provided
and uses \code{usethis::proj_set()} for setting the project directory. Users
do not need to rely on \code{usethis::proj_set()} under typical scenarios. In
other words, if you are running R interactively, \code{usethis} will set the
directory for you.

Check
\url{https://github.com/lcolladotor/biocthis/commit/dc387807623f0e945432d15f0d0f899de1b1dd9d#r39102094}
for more details that motivated this function.
}
\examples{

## Create an example temporary package for illustrative purposes
pkgdir <- biocthis_example_pkg()
}
