test_that("roclet_clean.roclet_longtests cleans up longtests directory", {
  # Setup:
  base_path <- tempdir()
  longtests_path <- file.path(base_path, "longtests", "testthat")
  unlink(base_path, recursive = TRUE, force = TRUE)

  # Check error when longtests directory does not exist
  expect_error(roclet_clean.roclet_longtests(NULL, base_path))

  # Act: Create a dummy longtests directory with some test files
  dir.create(longtests_path, recursive = TRUE, showWarnings = FALSE)
  file.create(file.path(longtests_path, "test-biocroxytest-1.R"))
  file.create(file.path(longtests_path, "test-biocroxytest-2.R"))
  c("# Generated by biocroxytest: do not edit by hand!") |>
    writeLines(file.path(longtests_path, "test-biocroxytest-3.R"))

  # Assert: Check three test files are created
  testfiles <- dir(
    path = longtests_path,
    pattern = "^test-biocroxytest-.*\\.[Rr]$",
    full.names = TRUE
  )
  expect_equal(length(testfiles), 3)

  # Act: Call the function to clean up the longtests directory
  roclet_clean.roclet_longtests(NULL, base_path) |>
    expect_snapshot()

  # Assert: Check that on file was deleted
  testfiles <- dir(
    path = longtests_path,
    pattern = "^test-biocroxytest-.*\\.[Rr]$",
    full.names = TRUE
  )
  expect_equal(length(testfiles), 2)
})
