% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva_tidiers.R
\name{augment_sva}
\alias{augment_sva}
\alias{tidy_sva}
\alias{glance_sva}
\title{Tidying methods for a sva list}
\usage{
augment_sva(x, data, ...)

tidy_sva(x, addVar = NULL, ...)

glance_sva(x, ...)
}
\arguments{
\item{x}{sva list}

\item{data}{Original data}

\item{...}{extra arguments (not used)}

\item{addVar}{add additional coefficients to the estimated surrogate variables}
}
\value{
All tidying methods return a \code{data.frame} without rownames.
The structure depends on the method chosen.

\code{augment} returns one row per gene. It always
contains the columns
  \item{pprob.gam}{Posterior probability each gene is affected by heterogeneity}
  \item{pprob.b}{Posterior probability each gene is affected by model}

\code{tidy} returns the estimate surrogate variables.

\code{glance} returns the estimate surrogate variables.
}
\description{
These are methods for turning a sva list, from the sva package, into a tidy data frame.
\code{tidy} returns a data.frame of the estimated surrogate variables, \code{glance} returns a data.frame
of the posterior probabilities, and \code{glance} returns a
data.frame with only the number of surrogate variables.
}
