% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBarPolarPlot.R
\name{makeBarPolarPlot}
\alias{makeBarPolarPlot}
\title{Create a bar/polar plot}
\usage{
makeBarPolarPlot(
  bettrList = NULL,
  plotdata,
  scoredata,
  idCol,
  metricCol = "Metric",
  valueCol = "ScaledValue",
  weightCol = "Weight",
  scoreCol = "Score",
  metricGroupCol = "metricGroup",
  metricColors,
  metricCollapseGroup = FALSE,
  metricGrouping = "---",
  methods = NULL,
  labelSize = 10,
  showComposition = FALSE,
  scaleFactorPolars = 1
)
}
\arguments{
\item{bettrList}{A \code{list}, the output object from \code{prepData}.
If \code{bettrList} is provided, arguments \code{plotdata},
\code{scoredata}, \code{idCol}, \code{metricCol}, \code{valueCol},
\code{weightCol}, \code{scoreCol}, \code{metricGroupCol},
\code{metricInfo}, \code{metricColors}, \code{idInfo}, \code{idColors},
\code{metricCollapseGroup}, \code{metricGrouping} and \code{methods}
will be ignored and the corresponding values will be extracted from
\code{bettrList}. This is the recommended way of calling the plotting
functions, as it ensures compatibility of all components.}

\item{plotdata}{A \code{data.frame} with columns representing methods,
metrics, scores, and weights. Typically obtained as
\code{prepData$plotdata}, where \code{prepData} is the output from
\code{bettrGetReady}.}

\item{scoredata}{A \code{data.frame} with columns representing methods,
aggregated scores, and any other method annotations. Typically
obtained as \code{prepData$scoredata}, where \code{prepData} is the
output from \code{bettrGetReady}.}

\item{idCol}{Character scalar indicating which column of \code{plotdata} and
\code{scoredata} contains the method IDs.}

\item{metricCol}{Character scalar indicating which column of \code{plotdata}
contains the metric IDs. Typically, \code{"Metric"}.}

\item{valueCol}{Character scalar indicating which column of \code{plotdata}
contains the metric values. Typically, \code{"ScaledValue"}.}

\item{weightCol}{Character scalar indicating which column of \code{plotdata}
contains the weight values. Typically, \code{"Weight"}.}

\item{scoreCol}{Character scalar indicating which column of \code{scoredata}
contains the aggregated score values. Typically, \code{"Score"}.}

\item{metricGroupCol}{Character scalar indicating which column of
\code{plotdata} contains the information about the metric group.
Typically, \code{"metricGroup"}.}

\item{metricColors}{Named list with colors used for the metrics and
any other metric annotations. Typically obtained as
\code{prepData$metricColors}, where \code{prepData} is the output from
\code{bettrGetReady}.}

\item{metricCollapseGroup}{Logical scalar indicating whether metrics
should be collapsed by the group variable provided by
\code{metricGrouping}. Typically obtained as
\code{prepData$metricCollapseGroup}, where \code{prepData} is the
output from \code{bettrGetReady}.}

\item{metricGrouping}{Character scalar indicating the column of
\code{metricInfo} that was used to group metrics. Typically obtained as
\code{prepData$metricGrouping}, where \code{prepData} is the output
from \code{bettrGetReady}.}

\item{methods}{Character vector containing the methods for which to make
polar plots. If \code{NULL} (default), all methods will be used.}

\item{labelSize}{Numeric scalar providing the size of the labels in the plot.}

\item{showComposition}{Logical scalar indicating whether to show the
composition of the score in the bar plots. This is only interpretable
if the scores are obtained via a weighted mean approach.}

\item{scaleFactorPolars}{Numeric scalar giving the scale factor determining
the size of the polar plots.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a bar/polar plot. The input arguments for this functions are
typically generated using \code{\link{bettrGetReady}}, which ensures that
all required columns are available.
}
\examples{
## Generate example data
df <- data.frame(Method = c("M1", "M2", "M3"),
                 metric1 = c(1, 2, 3),
                 metric2 = c(3, 1, 2))
metricInfo <- data.frame(Metric = c("metric1", "metric2", "metric3"),
                         Group = c("G1", "G2", "G2"))
idInfo <- data.frame(Method = c("M1", "M2", "M3"),
                     Type = c("T1", "T1", "T2"))
prepData <- bettrGetReady(df = df, idCol = "Method",
                          metricInfo = metricInfo, idInfo = idInfo)
makeBarPolarPlot(bettrList = prepData, showComposition = TRUE)

}
\author{
Charlotte Soneson
}
