% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\name{threshold_identification}
\alias{threshold_identification}
\alias{threshold_identification,matrix-method}
\alias{threshold_identification-methods}
\alias{threshold_identification,data.frame-method}
\title{HMM for beta valued DNA data for a single treatment condition}
\usage{
threshold_identification(object1, ...)

\S4method{threshold_identification}{matrix}(
  object1,
  package_workflow = TRUE,
  annotation_file = NULL,
  M = 3,
  N = 4,
  parameter_estimation_only = FALSE,
  seed = NULL,
  ...
)

\S4method{threshold_identification}{data.frame}(
  object1,
  package_workflow = TRUE,
  annotation_file = NULL,
  M = 3,
  N = 4,
  parameter_estimation_only = FALSE,
  seed = NULL,
  ...
)
}
\arguments{
\item{object1}{Methylation data and IlmnID. Maybe provided as a matrix
or dataframe.}

\item{...}{Extra parameters.}

\item{package_workflow}{Flag set to TRUE if method called from package
workflow.
If set to FALSE then the parameter annotation_file needs to be supplied to
the function.}

\item{annotation_file}{A dataframe containing the EPIC methylation
annotation file.}

\item{M}{Number of methylation states to be identified in a
single DNA sample.}

\item{N}{Number of DNA samples (patients/replicates) collected for each
treatment group.}

\item{parameter_estimation_only}{If only model parameters are to be
estimated then value is TRUE else FALSE.}

\item{seed}{Seed to allow for reproducibility (default = NULL).}
}
\value{
An S4 object of class \code{threshold_Results}.
}
\description{
The supported classes are \code{matrix} and \code{data.frame}.
The output of \code{threshold_identification} is an S4 object of
class \code{threshold_Results}.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)
library(betaHMM)

## read files
data(sample_methylation_file)
head(sample_methylation_file)
data(sample_annotation_file)
head(sample_annotation_file)
##merge data
df=merge(sample_annotation_file[,c('IlmnID','CHR','MAPINFO')],
sample_methylation_file,by='IlmnID')

## sort data
df=df[order(df$CHR,df$MAPINFO),]
thr_out=threshold_identification(df[,c(1,4:7)],package_workflow=TRUE,M=3,4,
parameter_estimation_only=TRUE,seed=12345)

}
