% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-functions.R
\name{dmc_identification_run}
\alias{dmc_identification_run}
\title{DMC identification from estimated betaHMM model parameters}
\usage{
dmc_identification_run(
  betaHMM_object,
  AUC_threshold = 0.8,
  uncertainty_threshold = 0.2,
  ...
)
}
\arguments{
\item{betaHMM_object}{A \code{\link[betaHMM:betaHMMResults]{betaHMMResults}}
object.}

\item{AUC_threshold}{The threshold for AUC metric for each chromosome.}

\item{uncertainty_threshold}{The threshold for uncertainty of belonging to
a particular hidden state, for each chromosome.}

\item{...}{extra arguments}
}
\value{
The function returns an object of the
\code{\link[betaHMM:dmcResults]{dmcResults}} class
which contains a SimpleList of assay data which contains the
following values:
\itemize{
\item CHR Chromosome number
\item MAPINFO Mapinfo
\item IlmnID IlmnID
\item N*R columns containing methylation states
\item hidden_state The assigned hidden_state
\item DMC The value is 1 if the CpG is a DMC else 0.}
The object contains the following values as the metadata:
\itemize{
\item A list containing the AUC values for K hidden states for each
chromosome and the conditions compared which resulted in the highest AUC
value when more than 2 conditions are compared.
\item A list containing the conditional probability values for K hidden
states for each chromosome.
\item The treatment group labels.
\item K The number of hidden states estimated.
\item N The number of DNA replicates/patients for each treatment group.
\item R The number of treatment groups to be compared.
}
}
\description{
The dissimilarities between the cumulative distributions
calculated for each hidden state are determined through employment of the
area-under-curve (AUC) technique. By incorporating user-defined threshold
values for AUC alongside the associated uncertainties in membership within
that hidden state, the aim is to pinpoint the most distinctively methylated
states. This process facilitates the identification of CpGs that exhibit the
most notable differential methylation, guided by the predefined threshold
criteria.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
