% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general-functions.R
\name{betaHMMrun}
\alias{betaHMMrun}
\title{The betaHMM model parameter estimation function}
\usage{
betaHMMrun(
  methylation_data,
  annotation_file,
  M,
  N,
  R,
  treatment_group = NULL,
  parallel_process = FALSE,
  seed = NULL,
  iterations = 100,
  ...
)
}
\arguments{
\item{methylation_data}{A dataframe of dimension \eqn{(C \times (N \times R)
)+1} containing methylation values for \eqn{C} CpG sites from \eqn{R}
treatment groups each having \eqn{N} DNA samples and the IlmnID
for each CpG site.}

\item{annotation_file}{A dataframe containing the EPIC methylation
annotation file.}

\item{M}{Number of methylation states to be identified in a
single DNA sample.}

\item{N}{Number of DNA samples (patients/replicates) collected for each
treatment group.}

\item{R}{Number of treatment groups (For. eg: Benign and Tumour).}

\item{treatment_group}{The names of each treatment groups/
conditions. If no value is passed then default values of sample names,
e.g. Sample 1, Sample 2, etc are used as legend text (default = NULL).}

\item{parallel_process}{The 'TRUE' option results in parallel processing of
the models for each chromosome for increased computational efficiency.
The default option has been set as 'FALSE' due to package testing
limitations.}

\item{seed}{Seed to allow for reproducibility (default = NULL).}

\item{iterations}{Number of iterations for algorithm convergence
(default=100).}

\item{...}{Extra arguments}
}
\value{
The function returns an object of the
\code{\link[betaHMM:betaHMMResults]{betaHMMResults}} class
which contains a SimpleList of assay data containing the posterior
probability of each CpG site belonging to each of the
\eqn{K} hidden states and the following values as metadata:
\itemize{
\item K - The number of hidden states identified using the betaHMM model.
\item C - The number of CpG sites analysed using the betaHMM model.
\item N - The number of DNA samples corresponding to each
treatment group analysed using the betaHMM model.
\item R - The number of treatment groups analysed using the betaHMM model.
\item A - The transition matrix estimated for the betaHMM model.
\item tau - The initial distribution estimated for the betaHMM model.
\item treatment_group - The names of the treatment
groups/conditions analysed.
\item phi - The shape parameters estimated for the observed data
in the betaHMM model.
\item llk - A vector containing the log-likelihood values calculated
for each iteration of the algorithm.
\item hidden_states - The vector containing the estimated hidden states
for each CpG sites. }
}
\description{
A homogeneous hidden Markov model for the beta valued DNA
methylation data.
}
\details{
The betaHMM function employs initially set parameters (utilizing a
basic 3-state beta hidden Markov model) to estimate the parameters of the
homogeneous hidden Markov model, adapted for beta-valued DNA methylation
data, through implementation of the Baum-Welch algorithm. Subsequently,
the derived parameters are utilized to ascertain the most probable sequence
of hidden states using the Viterbi algorithm.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)

## read files
data(sample_methylation_file)
data(sample_annotation_file)
# Run betaHMM function
beta_out <- betaHMM(sample_methylation_file[1:50,],
                    sample_annotation_file[1:50,],
                    M = 3, N = 4, R = 2,iterations=2,
                    parallel_process = FALSE, seed = 12345,
                    treatment_group = c("Benign","Tumour"))

## Run dmc_identification function
dmc_out <- dmc_identification(beta_out)

# Run dmr_identification function
dmr_out <- dmr_identification(dmc_out, parallel_process = FALSE)

# Plot functions
# Get the AUC values calculated for each hidden state
AUC_chr <- AUC(dmc_out)

## plot the uncertainty for each hidden state
plot(beta_out, chromosome = "1", what = "uncertainty")

}
