% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backward.R
\name{backward}
\alias{backward}
\title{Backward algorithm}
\usage{
backward(probabilities, trained_params)
}
\arguments{
\item{probabilities}{A matrix containing the marginal probability
distribution of the \eqn{K} hidden states within the Markov model.}

\item{trained_params}{A list containing the initialised shape parameters for
the betaHMM model (initial distribution, transition matrix, shape parameters
for the observed data).}
}
\value{
A list containing:
\itemize{
\item log_beta - A matrix of dimension \eqn{C*K} (where \eqn{C} is the
number of CpG sites and \eqn{K} is the number of hidden states) containing
the logarithmized backward probabilities.
\item scaled_logL - The log-likelihood calculated using the backward
probabilities.
}
}
\description{
Computes the backward probabilities for \eqn{K} hidden states
using the initial distribution, transition matrix and distribution
parameters.
}
\keyword{internal}
