% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_ZINB.R
\name{weights_ZINB}
\alias{weights_ZINB}
\title{weights_ZINB}
\usage{
weights_ZINB(
  object,
  assay_name = "counts",
  design,
  K = 0,
  commondispersion = TRUE,
  zeroinflation = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{design}{character name of the metadata columns, formula, or design
matrix with rows corresponding to samples and columns to coefficients to be
estimated (the user needs to explicitly include the intercept in the design).}

\item{K}{integer. Number of latent factors.}

\item{commondispersion}{Whether or not a single dispersion for all features
is estimated (default TRUE).}

\item{zeroinflation}{Whether or not a ZINB model should be fitted. If FALSE,
a negative binomial model is fitted instead.}

\item{verbose}{Print helpful messages.}

\item{...}{Additional parameters to describe the model, see
\code{\link[zinbwave]{zinbModel}}.}
}
\value{
A matrix of weights.
}
\description{
Computes the observational weights of the counts under a zero-inflated
negative binomial (ZINB) model. For each count, the ZINB distribution is
parametrized by three parameters: the mean value and the dispersion of the
negative binomial distribution, and the probability of the zero component.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
    phyloseq::sample_data(metadata))
# Calculate the ZINB weights
zinbweights <- weights_ZINB(object = ps, K = 0, design = "~ 1")
}
\seealso{
\code{\link[zinbwave]{zinbFit}} for zero-inflated negative binomial
parameters' estimation and
\code{\link[zinbwave]{computeObservationalWeights}} for weights extraction.
}
