% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_NOISeq.R
\name{set_NOISeq}
\alias{set_NOISeq}
\title{set_NOISeq}
\usage{
set_NOISeq(
  assay_name = "counts",
  pseudo_count = FALSE,
  contrast = NULL,
  norm = c("rpkm", "uqua", "tmm", "n"),
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{norm}{name of the normalization method to use in the differential 
abundance analysis. Choose between the native edgeR normalization methods, 
such as \code{TMM}, \code{TMMwsp}, \code{RLE}, \code{upperquartile}, 
\code{posupperquartile}, or \code{none}. Alternatively (only for advanced 
users), if \code{norm} is equal to "ratio", "poscounts", or "iterate" from 
\code{\link{norm_DESeq2}}, "CSS" from \code{\link{norm_CSS}}, or "TSS" from 
\code{\link{norm_TSS}}, the scaling factors are automatically transformed 
into normalization factors. If custom factors are supplied, make sure they 
are compatible with edgeR normalization factors.}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_NOISeq}
method.
}
\description{
Set the parameters for NOISeq differential abundance detection method.
}
\examples{
# Set a basic combination of parameters for NOISeq with 'tmm' normalization
base_NOISeq <- set_NOISeq(pseudo_count = FALSE, norm = "tmm",
    contrast = c("group", "B", "A"), expand = FALSE)
# try many normalizations
many_NOISeq <- set_NOISeq(pseudo_count = FALSE, 
    norm = c("tmm", "uqua", "rpkm", "n"), contrast = c("group", "B", "A"))
}
\seealso{
\code{\link{DA_NOISeq}}
}
