% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTIEC.R
\name{plotLogP}
\alias{plotLogP}
\title{plotLogP}
\usage{
plotLogP(df_pval = NULL, df_QQ = NULL, cols = NULL)
}
\arguments{
\item{df_pval}{a \code{data.frame} produced by the \code{\link{createTIEC}}
function, containing the p-values for each taxon, method, and mock 
comparison. It is used to draw the negative log10 p-values distribution.
If df_pval is supplied, let \code{df_QQ = NULL}.}

\item{df_QQ}{a \code{data.frame} produced by the \code{\link{createTIEC}}
function, containing the average p-values for each quantile and method. It is
used to draw the negative log10 average p-values distribution. If df_QQ is 
supplied, let \code{df_pval = NULL}.}

\item{cols}{named vector of colors.}
}
\value{
A ggplot object.
}
\description{
Draw the p-values or the average p-values distribution across the mock 
comparisons in logarithmic scale.
}
\examples{
# Load some data
data(ps_stool_16S)

# Generate the patterns for 10 mock comparison for an experiment
# (N = 1000 is suggested)
mocks <- createMocks(nsamples = phyloseq::nsamples(ps_stool_16S), N = 10)
head(mocks)

# Add some normalization/scaling factors to the phyloseq object
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_stool_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_stool_16S)

# Initialize some limma based methods
my_limma <- set_limma(design = ~ group, coef = 2,
    norm = c("TMM", "CSS"))

# Run methods on mock datasets
results <- runMocks(mocks = mocks, method_list = my_limma,
    object = ps_stool_16S)

# Prepare results for Type I Error Control
TIEC_summary <- createTIEC(results)

# Plot the results
plotFPR(df_FPR = TIEC_summary$df_FPR)
plotFDR(df_FDR = TIEC_summary$df_FDR)
plotQQ(df_QQ = TIEC_summary$df_QQ, zoom = c(0, 0.1))
plotKS(df_KS = TIEC_summary$df_KS)
plotLogP(df_QQ = TIEC_summary$df_QQ)
}
