% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_CSS.R
\name{norm_CSS}
\alias{norm_CSS}
\title{norm_CSS}
\usage{
norm_CSS(object, assay_name = "counts", method = "CSS", verbose = TRUE)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{method}{normalization method to be used (only CSS).}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A new column containing the CSS normalization factors is added to 
the \code{sample_data} slot of the phyloseq object or the \code{colData} 
slot of the TreeSummarizedExperiment object.
}
\description{
Calculate normalization factors from a phyloseq or TreeSummarizedExperiment
object. Inherited from metagenomeSeq 
\code{\link[metagenomeSeq]{calcNormFactors}} function which performs the 
Cumulative Sum Scaling normalization.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))

# Calculate the normalization factors
ps_NF <- norm_CSS(object = ps, method = "CSS")
# The phyloseq object now contains the normalization factors:
CSSFacts <- phyloseq::sample_data(ps_NF)[, "NF.CSS"]
head(CSSFacts)

# VERY IMPORTANT: metagenomeSeq uses scaling factors to normalize counts 
# (even though they are called normalization factors). These factors are used
# internally by a regression model. To make CSS size factors available for 
# edgeR, we need to transform them into normalization factors. This is 
# possible by dividing the factors for the library sizes and renormalizing. 
normCSSFacts = CSSFacts / colSums(phyloseq::otu_table(ps_stool_16S))
# Renormalize: multiply to 1
normFacts = normCSSFacts/exp(colMeans(log(normCSSFacts)))
}
\seealso{
\code{\link[metagenomeSeq]{calcNormFactors}} for details.
\code{\link{setNormalizations}} and \code{\link{runNormalizations}} to fastly
set and run normalizations.
}
