% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.R
\name{createConcordance}
\alias{createConcordance}
\title{createConcordance}
\usage{
createConcordance(object, slot = "pValMat", colName = "rawP", type = "pvalue")
}
\arguments{
\item{object}{Output of differential abundance detection methods.
\code{pValMat}, \code{statInfo} matrices, and method's \code{name} must be
present (See vignette for detailed information).}

\item{slot}{A character vector with 1 or number-of-methods-times repeats of
the slot names where to extract values for each method
(default \code{slot = "pValMat"}).}

\item{colName}{A character vector with 1 or number-of-methods-times repeats
of the column name of the slot where to extract values for each method
(default \code{colName = "rawP"}).}

\item{type}{A character vector with 1 or number-of-methods-times repeats
of the value type of the column selected where to extract values for each
method. Two values are possible: \code{"pvalue"} or \code{"logfc"}
(default \code{type = "pvalue"}).}
}
\value{
A long format \code{data.frame} object with several columns:
\describe{
    \item{\code{comparison}}{ which indicates the comparison number;}
    \item{\code{n_features}}{ which indicates the total number of taxa in
    the comparison dataset;}
    \item{\code{method1}}{ which contains the first method name;}
    \item{\code{method2}}{ which contains the first method name;}
    \item{\code{rank}}{;}
    \item{\code{concordance}}{ which is defined as the cardinality of the
    intersection of the top rank elements of each list, divided by rank, i.e.
    , \eqn{(L_{1:rank} \bigcap M_{1:rank})/(rank)}, where L and M represent
    the lists of the extracted statistics of method1 and method2
    respectively (averaged values between subset1 and subset2).}}
}
\description{
Compute the between and within method concordances comparing the lists of
extracted statistics from the outputs of the differential abundance detection
methods.
}
\examples{
data(ps_plaque_16S)

# Balanced design
my_splits <- createSplits(
    object = ps_plaque_16S, varName = "HMP_BODY_SUBSITE", balanced = TRUE,
    paired = "RSID", N = 10 # N = 100 suggested
)

# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])

# Initialize some limma based methods
my_limma <- set_limma(design = ~ RSID + HMP_BODY_SUBSITE, 
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = c("TMM", "CSS"))

# Set the normalization methods according to the DA methods
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))

# Run methods on split datasets
results <- runSplits(split_list = my_splits, method_list = my_limma,
    normalization_list = my_norm, object = ps_plaque_16S)

# Concordance for p-values
concordance_pvalues <- createConcordance(
    object = results, slot = "pValMat", colName = "rawP", type = "pvalue"
)

# Concordance for log fold changes
concordance_logfc <- createConcordance(
    object = results, slot = "statInfo", colName = "logFC", type = "logfc"
)

# Concordance for log fold changes in the first method and p-values in the
# other
concordance_logfc_pvalues <- createConcordance(
    object = results, slot = c("statInfo", "pValMat"),
    colName = c("logFC", "rawP"), type = c("logfc", "pvalue")
)
}
\seealso{
\code{\link{extractStatistics}} and \code{\link{areaCAT}}.
}
