% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concordance.R
\name{areaCAT}
\alias{areaCAT}
\title{areaCAT}
\usage{
areaCAT(concordance, plotIt = FALSE)
}
\arguments{
\item{concordance}{A long format \code{data.frame} produced by
\link{createConcordance} function.}

\item{plotIt}{Plot the concordance (default \code{plotIt = FALSE}).}
}
\value{
A long format \code{data.frame} object with several columns:
\describe{
    \item{\code{comparison}}{ which indicates the comparison number;}
    \item{\code{n_features }}{ which indicates the total number of taxa in
    the comparison dataset;}
    \item{\code{method1}}{ which contains the first method name;}
    \item{\code{method2}}{ which contains the first method name;}
    \item{\code{rank}}{;}
    \item{\code{concordance}}{ which is defined as the cardinality of the
    intersection of the top rank elements of each list, divided by rank, i.e.
    , \eqn{(L_{1:rank} \bigcap M_{1:rank})/(rank)}, where L and M represent
    the lists of the extracted statistics of method1 and method2
    respectively;}
    \item{\code{heightOver}}{ which is the distance between the bisector and
    the concordance value;}
    \item{\code{areaOver}}{ which is the cumulative sum of the
    \code{heightOver} value.}}
}
\description{
Compute the area between the bisector and the concordance curve.
}
\examples{
data(ps_plaque_16S)

# Balanced design for dependent samples
my_splits <- createSplits(
    object = ps_plaque_16S, varName = "HMP_BODY_SUBSITE", 
    balanced = TRUE, paired = "RSID", N = 10 # N = 100 suggested
)

# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])

# Initialize some limma based methods
my_limma <- set_limma(design = ~ RSID + HMP_BODY_SUBSITE, 
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = c("TMM", "CSS"))

# Set the normalization methods according to the DA methods
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))

# Run methods on split datasets
results <- runSplits(split_list = my_splits, method_list = my_limma,
    normalization_list = my_norm, object = ps_plaque_16S)

# Concordance for p-values
concordance_pvalues <- createConcordance(
    object = results, slot = "pValMat", colName = "rawP", type = "pvalue"
)

# Add area over the concordance curve
concordance_area <- areaCAT(concordance = concordance_pvalues)
}
\seealso{
\code{\link{createConcordance}} and \code{\link{plotConcordance}}
}
