% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{addKnowledge}
\alias{addKnowledge}
\title{addKnowledge}
\usage{
addKnowledge(method, priorKnowledge, enrichmentCol, namesCol = NULL)
}
\arguments{
\item{method}{Output of differential abundance detection method in which
DA information is extracted by the \code{getDA} function.}

\item{priorKnowledge}{\code{data.frame} (with feature names as
\code{row.names}) containing feature level metadata.}

\item{enrichmentCol}{name of the column containing information for enrichment
analysis.}

\item{namesCol}{name of the column containing new names for features (default
\code{namesCol = NULL}).}
}
\value{
A \code{data.frame} with a new column containing information for
enrichment analysis.
}
\description{
Add a priori knowledge for each feature tested by a method.
}
\examples{
data("ps_plaque_16S")
data("microbial_metabolism")

# Extract genera from the phyloseq tax_table slot
genera <- phyloseq::tax_table(ps_plaque_16S)[, "GENUS"]
# Genera as rownames of microbial_metabolism data.frame
rownames(microbial_metabolism) <- microbial_metabolism$Genus
# Match OTUs to their metabolism
priorInfo <- data.frame(genera,
    "Type" =  microbial_metabolism[genera, "Type"])
# Unmatched genera becomes "Unknown"
unknown_metabolism <- is.na(priorInfo$Type)
priorInfo[unknown_metabolism, "Type"] <- "Unknown"
priorInfo$Type <- factor(priorInfo$Type)
# Add a more informative names column
priorInfo[, "newNames"] <- paste0(rownames(priorInfo), priorInfo[, "GENUS"])

# DA Analysis

# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])

# Add scaling factors
ps_plaque_16S <- norm_edgeR(object = ps_plaque_16S, method = "TMM")

# DA analysis
da.limma <- DA_limma(
    object = ps_plaque_16S,
    design = ~ 1 + RSID + HMP_BODY_SUBSITE,
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = "TMM"
)

DA <- getDA(method = da.limma, slot = "pValMat", colName = "adjP",
    type = "pvalue", direction = "logFC", threshold_pvalue = 0.05,
    threshold_logfc = 1, top = NULL)
    
# Add a priori information
DA_info <- addKnowledge(method = DA, priorKnowledge = priorInfo,
    enrichmentCol = "Type", namesCol = "newNames")
}
\seealso{
\code{\link{createEnrichment}}.
}
