% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_limma.R
\name{DA_limma}
\alias{DA_limma}
\title{DA_limma}
\usage{
DA_limma(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  design = NULL,
  coef = 2,
  norm = c("TMM", "TMMwsp", "RLE", "upperquartile", "posupperquartile", "none"),
  weights,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{design}{character name of the metadata columns, formula, or design
matrix with rows corresponding to samples and columns to coefficients to be
estimated.}

\item{coef}{integer or character index vector indicating which coefficients
of the linear model are to be tested equal to zero.}

\item{norm}{name of the normalization method to use in the differential 
abundance analysis. Choose between the native edgeR normalization methods, 
such as \code{TMM}, \code{TMMwsp}, \code{RLE}, \code{upperquartile}, 
\code{posupperquartile}, or \code{none}. Alternatively (only for advanced 
users), if \code{norm} is equal to "ratio", "poscounts", or "iterate" from 
\code{\link{norm_DESeq2}}, "CSS" from \code{\link{norm_CSS}}, or "TSS" from 
\code{\link{norm_TSS}}, the scaling factors are automatically transformed 
into normalization factors. If custom factors are supplied, make sure they 
are compatible with edgeR normalization factors.}

\item{weights}{an optional numeric matrix giving observational weights.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`, the matrix
of summary statistics for each tag `statInfo`, and a suggested `name` of the
final object considering the parameters passed to the function.
}
\description{
Fast run for limma voom differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Calculate the TMM normalization factors
ps_NF <- norm_edgeR(object = ps, method = "TMM")
# The phyloseq object now contains the normalization factors:
normFacts <- phyloseq::sample_data(ps_NF)[, "NF.TMM"]
head(normFacts)
# Differential abundance
DA_limma(object = ps_NF, pseudo_count = FALSE, design = ~ group, coef = 2,
    norm = "TMM")
}
\seealso{
\code{\link[limma]{voom}} for the mean-variance relationship
estimation, \code{\link[limma]{lmFit}} for the linear model framework.
}
