% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brew.R
\name{brew}
\alias{brew}
\title{Bayesian Enrichment Estimation in R (BEER)}
\usage{
brew(
  object,
  prior.params = list(method = "edgeR", a_pi = 2, b_pi = 300, a_phi = 1.25, b_phi =
    0.1, a_c = 80, b_c = 20, fc = 1),
  beads.args = list(lower = 1),
  se.params = list(method = "mle"),
  jags.params = list(n.chains = 1, n.adapt = 1000, n.iter = 10000, thin = 1, na.rm =
    TRUE, burn.in = 0, post.thin = 1, seed = as.numeric(format(Sys.Date(), "\%Y\%m\%d"))),
  sample.dir = NULL,
  assay.names = c(phi = NULL, phi_Z = "logfc", Z = "prob", c = "sampleInfo", pi =
    "sampleInfo"),
  beadsRR = FALSE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{object}{PhIPData object}

\item{prior.params}{named list of prior parameters}

\item{beads.args}{named list of parameters supplied to estimating beads-only
prior parameters (a_0, b_0)}

\item{se.params}{named list of parameters specific to identifying clearly
enriched peptides}

\item{jags.params}{named list of parameters for running MCMC using JAGS}

\item{sample.dir}{path to temporarily store RDS files for each sample run,
if \code{NULL} then \code{[base::tempdir]} is used to temporarily store
MCMC output and cleaned afterwards.}

\item{assay.names}{named vector indicating where MCMC results should be
stored in the PhIPData object}

\item{beadsRR}{logical value specifying whether each beads-only sample
should be compared to all other beads-only samples.}

\item{BPPARAM}{\code{[BiocParallel::BiocParallelParam]} passed to
BiocParallel functions.}
}
\value{
A PhIPData object with BEER results stored in the locations specified
by \code{assay.names}.
}
\description{
Run BEER to estimate posterior probabilities of enrichment, sample-specific
attenuation constants, relative fold-changes in comparison to beads-only
samples, and proportion of peptides enriched per sample as described in
Chen et. al. See \emph{Details} for more information on input parameters.
}
\details{
\strong{\code{prior.params}}. List of prior parameters. Parameters
include,
\itemize{
    \item \code{method}: method used to estimate beads-only prior parameters
    a_0, b_0. Valid methods include 'custom' or any of the methods specified
    in \code{\link{getAB}}. If \code{method = 'custom'} is specified,
    \code{a_0} and \code{b_0} must be included in the list of prior
    parameters. \code{'edgeR'} is used as the default method for estimating
    a_0, b_0.
    \item \code{a_pi}, \code{b_pi}: prior shape parameters for the proportion
    of peptides enriched in a sample. Defaults to 2 and 300, respectively.
    \item \code{a_phi}, \code{b_phi}: prior shape parameters of the gamma
    distribution that describe the valid range of enriched-fold changes. The
    shift is specified by \code{fc}. The default values of \code{a_phi} and
    \code{b_phi} are 1.25 and 0.1, respectively.
    \item \code{a_c}, \code{b_c}: prior shape parameters for the attenuation
    constant. Default values for \code{a_c} and \code{b_c} are 80 and 20.
    \item{\code{fc}}: minimum fold change for an enriched-peptide. \code{fc}
    describes the shift in the gamma distribution.
}

\strong{\code{beads.args}}. Named list of parameters supplied to
\code{\link{getAB}}. The estimation method used is specified in
\code{prior.params}, but other valid parameters include lower and upper
bounds for elicited parameters. As JAGS recommends that \eqn{a, b > 1} for
the beta distribution, \code{beads.args} defaults to \code{list(lower = 1)}.

\strong{\code{se.params}}. Named list of parameters supplied to
\code{\link{guessEnriched}}. By default \code{list(method = 'mle')} is
used to identify clearly enriched peptides.

\strong{\code{jags.params}}. Named list of parameters for MCMC sampling. By
default, BEER only runs one chain with 1,000 adaptation iteration and 10,000
sampling iterations. If unspecified, BEER uses the current date as the seed.

\strong{\code{sample.dir}}. Path specifying where to store the intermediate
results. If \code{NULL}, then results are stored in the default temporary
directory. Otherwise, the MCMC samples for running BEER on each sample is
stored as a single \code{RDS} file in the specified directory.

\strong{\code{assay.names}}. Named list specifying where to store the point
estimates. If \code{NULL}, estimates are not added to the PhIPData object.
Valid exported estimates include,
\itemize{
    \item \code{phi}: fold-change estimate after marginalizing over the
    posterior probability of enrichment. By default point estimates are not
    exported.
    \item \code{phi_Z}: fold-change estimate presuming the peptide is
    enriched. By default \code{phi_Z} estimates are stored in \code{'logfc'}
    assay.
    \item \code{Z}: posterior probability of enrichment. Estimates are stored
    in the \code{'prob'} assay by default.
    \item \code{c}: attenuation constant estimates. Stored in
    \code{'sampleInfo'} by default.
    \item \code{pi}: point estimates for the proportion of peptides enriched
    in a sample. Stored in \code{'sampleInfo'} by default.
}
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

## Default back-end evaluation
brew(sim_data)

## Serial
brew(sim_data, BPPARAM = BiocParallel::SerialParam())

## Snow
brew(sim_data, BPPARAM = BiocParallel::SnowParam())
}
\seealso{
\code{[BiocParallel::BiocParallelParam]} for subclasses,
\code{\link{beadsRR}} for running each beads-only sample against all
remaining samples, \code{\link{getAB}} for more information about valid
 parameters for estimating beads-only prior parameters,
\code{\link{guessEnriched}} for more information about how clearly
enriched peptides are identified, and \code{[rjags::jags.model]} for
MCMC sampling parameters.
}
