% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedbaser.R
\name{bb_list_beds}
\alias{bb_list_beds}
\title{List BEDs}
\usage{
bb_list_beds(
  bedbase,
  genome = NULL,
  bed_compliance = NULL,
  limit = 1000,
  offset = 0
)
}
\arguments{
\item{bedbase}{BEDbase() object}

\item{genome}{character(1) (default \code{NULL}) genome keyword}

\item{bed_compliance}{character(1) (default \code{NULL}) bed compliance,
e.g., 'bed6+4'}

\item{limit}{integer(1) (default \code{1000}) maximum records}

\item{offset}{integer(1) (default \code{0}) page token of records}
}
\value{
\link[tibble:tibble]{tibble} of BED records
}
\description{
List BED files available through
\href{https://api.bedbase.org}{bedhost}. By default uses the bedhost default
of 1000 records and an initial offset of 0.
}
\examples{
bedbase <- BEDbase()
bb_list_beds(bedbase)

}
