\name{transformFunctions}
\alias{logRedChannelTransform}
\alias{logGreenChannelTransform}
\alias{logRatioTransform}
\alias{greenChannelTransform}
\alias{redChannelTransform}

\title{
Functions for transforming the data store in a \code{beadLevelData} object for easier visualisation or summarisation.
}
\description{
Functions for transforming the data store in a \code{beadLevelData} object for easier visualisation or summarisation.
}
\usage{
logGreenChannelTransform(BLData, array)
logRedChannelTransform(BLData, array)
logRatioTransform(BLData, array)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{BLData}{
\code{beadLevelData} object

}
  \item{array}{
numeric specifying the section to be transformed
}
}
\details{
beadarray aims to support the whole range of data that can be generated by the Illumina BeadArray technology and allows users to build upon the functionality in the package to make pipeline to automtically process their own data and develop new methodologies. Therefore we have made the quality assessment and summarisation tools general enough to take any kind of values that can be derived from the beadLevelData object. This is achieved by the definition of transformation functions that can be used throughout the package whenever a function is operating on data on a per-section basis.

The default transformation is to take the data from the Green channel (column Grn in the beadLevelData object) and perform a log2 transformation and is the default to functions such as \code{boxplot} or \code{imageplot}.

Users with two channel data (e.g. data from methylation and SNP assays) can use the \code{logRedChannelTransform} function which instead extracts the red channel on the log2 scale or \code{logRatioTransform}. 

}

\value{

Transformation functions return a numeric vector with the same length as the number of beads for the particular section.

}

\author{
Mark Dunning
}

\examples{

if(require(beadarrayExampleData)){

data(exampleBLData)

head(exampleBLData[[1]])

log2(getBeadData(exampleBLData, array=1,what="Grn")[1:10])

logGreenChannelTransform(exampleBLData, array=1)[1:10]

}


}

