% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayNorm.r
\name{bayNorm}
\alias{bayNorm}
\title{A wrapper function of prior estimation and bayNorm function}
\usage{
bayNorm(
  Data,
  BETA_vec = NULL,
  Conditions = NULL,
  UMI_sffl = NULL,
  Prior_type = NULL,
  mode_version = FALSE,
  mean_version = FALSE,
  S = 20,
  parallel = TRUE,
  NCores = 5,
  FIX_MU = TRUE,
  GR = FALSE,
  BB_SIZE = TRUE,
  verbose = TRUE,
  out.sparse = FALSE
)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix,
is named "Counts"), just \code{matrix} or sparse matrix.}

\item{BETA_vec}{A vector of capture efficiencies
(probabilities) of cells.
If it is null, library size (total count) normalized to
0.06 will be used
as the input \code{BETA_vec}. \code{BETA_vec} less and
equal to 0 or greater and equal to 1 will be replaced
by the minimum and maximum of the \code{BETA_vec} which
range between (0,1) respectively.}

\item{Conditions}{vector of condition labels,
this should correspond to the columns of the Data. D
efault is NULL, which assumes that all cells
belong to the same group.}

\item{UMI_sffl}{Scaling factors are required only for
non-UMI based data for which \code{Data} is devided by
\code{UMI_sffl}. If non-null and \code{Conditions} is non-null,
then UMI_sffl should be a vector of length equal
to the number of groups. Default is \code{NULL}.}

\item{Prior_type}{Determines what groups of cells is used
in estimating prior using \code{Conditions}.
Default is \code{NULL}.
If \code{Conditions} is \code{NULL},
priors are estimated based on all cells.
If \code{Conditions} is not \code{NULL} and
if \code{Prior_type} is LL,
priors are estimated within each group respectively.
If \code{Prior_type} is GG, priors are estimated based on cells
from all groups. LL is suitable for DE detection.
GG is preferred if reduction of batch effect between
samples are desired for example for technical replicates
(see bayNorm paper).}

\item{mode_version}{If TRUE, bayNorm return modes of
posterior estimates as normalized data which is a 2D matrix
rather than samples from posterior which is a 3D array.
Default is FALSE.}

\item{mean_version}{If TRUE, bayNorm return means of
posterior estimates as normalized data, which is a 2D matrix
rather than samples from posterior which is a 3D array.
Default is FALSE.}

\item{S}{The number of samples you would like to
generate from estimated posterior distribution
(The third dimension of 3D array). Default is 20.
 S needs to be specified if \code{mode_version}=FALSE.}

\item{parallel}{If TRUE, \code{NCores} cores will be
used for parallelization. Default is TRUE.}

\item{NCores}{number of cores to use, default is 5.
This will be used to set up a parallel environment
using either MulticoreParam (Linux, Mac) or
SnowParam (Windows) with NCores using
the package BiocParallel.}

\item{FIX_MU}{Whether fix mu (the mean parameter of prior
distribution) to its MME estimate, when estimating prior
parameters by maximizing marginal distribution. If TRUE,
then 1D optimization is used, otherwise 2D optimization
for both mu and size is used (slow). Default is TRUE.}

\item{GR}{If TRUE, the gradient function will be used
in optimization. However since the gradient function
itself is very complicated, it does not help too much
in speeding up. Default is FALSE.}

\item{BB_SIZE}{If TRUE, estimate size parameter of
prior using maximization of marginal likelihood,
and then use it for adjusting MME estimate of SIZE Default is TRUE.}

\item{verbose}{print out status messages. Default is TRUE.}

\item{out.sparse}{Only valid for mean version: 
Whether the output is of type dgCMatrix or not. 
Default is FALSE.}
}
\value{
List containing 3D arrays of normalized
expression (if \code{mode_version}=FALSE) or 2D matrix
of normalized expression (if \code{mode_version}=TRUE
or \code{mean_version}=TRUE),
a list contains estimated priors and a list contains
input parameters used: \code{BETA_vec},
\code{Conditions} (if specified),
\code{UMI_sffl} (if specified), \code{Prior_type},
\code{FIX_MU}, \code{BB_SIZE} and \code{GR}.
}
\description{
This is the main wrapper function for bayNorm.
The input is a matrix of raw scRNA-seq data and a vector of
capture efficiencies of cells. You can also specify the
condition of cells for normalizing multiple groups
of cells separately.
}
\details{
A wrapper function of prior estimation
and bayNorm function.
}
\examples{
data('EXAMPLE_DATA_list')
#Return 3D array normalzied data:
bayNorm_3D<-bayNorm(
Data=EXAMPLE_DATA_list$inputdata[,seq(1,30)],
BETA_vec = EXAMPLE_DATA_list$inputbeta[seq(1,30)],
mode_version=FALSE,parallel =FALSE)


}
\references{
Wenhao Tang, Francois Bertaux, Philipp Thomas,
Claire Stefanelli, Malika Saint, Samuel
Blaise Marguerat, Vahid Shahrezaei
bayNorm: Bayesian gene expression recovery,
imputation and normalisation for single cell RNA-sequencing data
Bioinformatics, btz726; doi: 10.1093/bioinformatics/btz726
}
