% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthetic_controls.r
\name{SyntheticControl}
\alias{SyntheticControl}
\title{Generate synthetic control}
\usage{
SyntheticControl(Data, BETA_vec)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix and
is named "Counts") or just matrix.}

\item{BETA_vec}{A vector of capture efficiencies
(probabilities) of cells.}
}
\value{
List containing 2D matrix of synthetic control,
\code{BETA_vec} used and \code{lambda} used
in \code{rpois}.
}
\description{
Input raw data and a vector of capture
efficiencies of cells.
}
\details{
Simulate control data (based on Poisson
distribution).
}
\examples{
data("EXAMPLE_DATA_list")
SC_output<-SyntheticControl(Data=
EXAMPLE_DATA_list$inputdata,
BETA_vec = EXAMPLE_DATA_list$inputbeta)
}
