% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sup_funs.R
\name{AdjustSIZE_fun}
\alias{AdjustSIZE_fun}
\title{Adjust MME size estimate}
\usage{
AdjustSIZE_fun(BB_SIZE, MME_MU, MME_SIZE)
}
\arguments{
\item{BB_SIZE}{size estimated from \code{BB_Fun}.}

\item{MME_MU}{mu estimated from EstPrior.}

\item{MME_SIZE}{size estimated from EstPrior.}
}
\value{
MME_SIZE_adjust: A vector of estimated size.
Adjusted MME_SIZE based on BB_SIZE
(size estimated by maximizing marginal distribution)
}
\description{
This function adjusts MME estimated size parameter
of prior, which is a negative binomial distribution,
using estimates from maximizing marginal distirbution
(\code{BB_SIZE}). Simulation studies has shown this hybrid
method of using adjusted MME size estimates is the most
robust (see bayNorm paper). Hence, this is the default
option for estimating size in bayNorm.
}
\examples{
data('EXAMPLE_DATA_list')
MME_MU<-rlnorm(100,meanlog=5,sdlog=1)
MME_SIZE<-rlnorm(100,meanlog=1,sdlog=1)
BB_SIZE<-rlnorm(100,meanlog=0.5,sdlog=1)
adjustt<-AdjustSIZE_fun(BB_SIZE, MME_MU, MME_SIZE)
}
