% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkInputs.R
\name{checkBatchConsistency}
\alias{checkBatchConsistency}
\alias{checkIfSCE}
\alias{checkRestrictions}
\title{Check batch inputs}
\usage{
checkBatchConsistency(batches, cells.in.columns = TRUE)

checkIfSCE(batches)

checkRestrictions(batches, restrictions, cells.in.columns = TRUE)
}
\arguments{
\item{batches}{A list of batches, usually containing gene expression matrices or \linkS4class{SingleCellExperiment} objects.}

\item{cells.in.columns}{A logical scalar specifying whether batches contain cells in the columns.}

\item{restrictions}{A list of length equal to \code{batches}, specifying the cells in each batch that should be used for correction.}
}
\value{
\code{checkBatchConsistency} return an invisible \code{NULL} if there are no errors.

\code{checkIfSCE} will return a logical vector specifying whether each element of \code{batches} is a SingleCellExperiment objects.

\code{checkRestrictions} will return \code{NULL} if \code{restrictions=NULL}.
Otherwise, it will return a list by taking \code{restrictions} and converting each non-\code{NULL} element into an integer subsetting vector.
}
\description{
Utilities to check inputs into batch correction functions.
}
\details{
These functions are intended for internal use and other package developers.

\code{checkBatchConsistency} will check whether the input \code{batches} are consistent with respect to the size of the dimension containing features (i.e., not cells).
It will also verify that the dimension names are consistent, to avoid problems from variable ordering of rows/columns in the inputs.

\code{checkRestrictions} will check whether \code{restrictions} are consistent with the supplied \code{batches},
in terms of the length and names of the two lists.
It will also check that each batch contains at least one usable cell after restriction.
}
\examples{
checkBatchConsistency(list(cbind(1:5), cbind(1:5, 2:6)))
try( # fails
    checkBatchConsistency(list(cbind(1:5), cbind(1:4, 2:5)))
)

}
\seealso{
\code{\link{divideIntoBatches}}
}
\author{
Aaron Lun
}
