% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeBatches.R
\name{normalizeBatches}
\alias{normalizeBatches}
\alias{normalizeBatches,ANY-method}
\alias{normalizeBatches,SummarizedExperiment-method}
\title{Between-batch normalisation}
\usage{
normalizeBatches(peakTableCorr, ...)

\S4method{normalizeBatches}{ANY}(
  peakTableCorr,
  batches,
  sampleGroup,
  refGroup = "QC",
  population = "all",
  CVlimit = 0.3,
  FCLimit = 5,
  medianZero = c("mean", "min")
)

\S4method{normalizeBatches}{SummarizedExperiment}(peakTableCorr, batches, sampleGroup, assay.type, name, ...)
}
\arguments{
\item{peakTableCorr}{SummarizedExperiment object or matrix}

\item{...}{parameters with same behavior across methods}

\item{batches}{character scalar or factor, batch labels}

\item{sampleGroup}{character scalar or character, group labels}

\item{refGroup}{character scalar, identifier of reference samples
(default = "QC")}

\item{population}{character scalar, identifier of population samples in 
sampleGroups (default: "all")}

\item{CVlimit}{numeric scalar, coefficient of variance threshold for 
normalizing each batch by reference samples (default: 0.3)}

\item{FCLimit}{numeric scalar, fold-change between average intensity in 
batches threshold for normalizing each batch by reference samples 
(default: 5)}

\item{medianZero}{character scalar, strategy for substituting median value 
for population normalization when median is zero (-> Inf). Either 'mean' or 
'min' (default: "min, i.e. lowest non-zero value)}

\item{assay.type}{character scalar, assay to be used in case of multiple
assays}

\item{name}{character scalar, name of the resultant assay in case of 
multiple assays}
}
\value{
An list object containing:
A SummarizedExperiment object with the normalized peak table or a list, 
including the normalized matrix and processing information:
\itemize{
  \item peakTable: normalised peak table
  \item refCorrected: boolean matrix with information on which batches were 
    normalised by reference samples; else normalised by population median 
}
}
\description{
Batches are feature-wise normalised by Ref samples if passing heuristic 
criteria (CV and fold change). Otherwise normalized by population median.
}
\details{
A basic method for matrix (samples as rows) and SummarizedExperiment is 
supported. For grouping variables such as sampleGroup, the basic method 
expects vectors, while the SummarizedExperiment method expects the names of 
the respective columns. The basic method returns a list with the normalized 
peak table and information about the process, whereas the 
SummarizedExperiment method assigns the normalized peak table to the object 
supplied.
}
\examples{
# Note that the example data does not include any biological samples
data("ThreeBatchData")
normData <- normalizeBatches(
    peakTableCorr = PTfill, batches = meta$batch,
    sampleGroup = meta$grp, refGroup = "Ref",
    population = "all"
)

# With SummarizedExperiment
peaks <- SimpleList(t(PTnofill), t(PTfill))
sampleData <- meta
featureData <- peakInfo(PT = PTnofill, sep = "@", start = 3)
rownames(featureData) <- rownames(peaks[[1]])
se <- SummarizedExperiment(assays = peaks, colData = sampleData, 
                           rowData = featureData)
names(assays(se)) <- c("nofill", "fill")

se <- normalizeBatches(
    peakTableCorr = se, batches = "batch", sampleGroup = "grp", 
    refGroup = "Ref", population = "all", assay.type = "fill",
    name = "normalized"
)

}
