% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctDrift.R
\name{correctDrift}
\alias{correctDrift}
\alias{correctDrift,ANY-method}
\alias{correctDrift,SummarizedExperiment-method}
\title{Within-batch signal intensity drift correction}
\usage{
correctDrift(peakTable, ...)

\S4method{correctDrift}{ANY}(
  peakTable,
  injections,
  sampleGroups,
  QCID = "QC",
  RefID = "none",
  modelNames = c("VVV", "VVE", "VEV", "VEE", "VEI", "VVI", "VII"),
  G = seq(5, 35, by = 10),
  smoothFunc = "spline",
  spar = 0.2,
  CVlimit = 0.3,
  report = TRUE,
  reportPath = NULL
)

\S4method{correctDrift}{SummarizedExperiment}(peakTable, injections, sampleGroups, assay.type, name, ...)
}
\arguments{
\item{peakTable}{SummarizedExperiment object or matrix}

\item{...}{parameters with same behavior across methods}

\item{injections}{character scalar or numeric, injection order}

\item{sampleGroups}{character scalar or character, group labels}

\item{QCID}{character scalar, identifier of QC samples}

\item{RefID}{character scalar, identifier of external reference 
samples for unbiased assessment of drift correction}

\item{modelNames}{character, Which mclust geometries to test}

\item{G}{integer, numbers of clusters to test}

\item{smoothFunc}{character scalar, choice of regression function: 
spline or loess (default: spline)}

\item{spar}{numeric, smoothing parameter value (defaults to 0.2)}

\item{CVlimit}{coefficient of variance threshold for filtering 
(default = 0.3)}

\item{report}{boolean, whether to print pdf reports of drift models}

\item{reportPath}{character scalar, directory path for report}

\item{assay.type}{character scalar, assay of to be used in case of multiple 
assays}

\item{name}{character scalar, name of the resultant assay in case of multiple
assays}
}
\value{
A SummarizedExperiment object with the corrected and filtered matrix 
or a list, including the corrected and filtered matrix as well as processing 
information:
\itemize{
  \item actionInfo: see what happened to each cluster
  \item TestFeatsCorr: to extract drift-corrected data
  \item TestFeatsFinal: to extract drift-corrected data which pass the 
    criterion QC CV < CVlimit
}
}
\description{
Correct drift with cluster-based drift correction.
}
\details{
A basic method for matrix (samples as rows) and SummarizedExperiment is 
supported. For grouping variables such as sampleGroups, the basic method 
expects vectors, while the SummarizedExperiment method expects the names of 
the respective columns. The basic method returns a list with the corrected 
peak table and information about the process, whereas the 
SummarizedExperiment method assigns the corrected peak table to the object 
supplied.
}
\examples{
data("ThreeBatchData")
set.seed(2024)
# Get batches
batchB <- getBatch(
    peakTable = PTfill, meta = meta,
    batch = meta$batch, select = "B"
)
batchF <- getBatch(
    peakTable = PTfill, meta = meta,
    batch = meta$batch, select = "F"
)
# Drift correction using QCs
BCorr <- correctDrift(
    peakTable = batchB$peakTable,
    injections = batchB$meta$inj,
    sampleGroups = batchB$meta$grp, QCID = "QC",
    G = seq(5, 35, by = 3), modelNames = c("VVE", "VEE"),
    report = FALSE
)
# Using SummarizedExperiment, more unbiased drift correction using QCs &
# external reference samples
## Construct SummarizedExperiment
peaks <- SimpleList(t(PTnofill), t(PTfill))
sampleData <- meta
featureData <- peakInfo(PT = PTnofill, sep = "@", start = 3)
rownames(featureData) <- rownames(peaks[[1]])
se <- SummarizedExperiment(assays = peaks, colData = sampleData, 
                           rowData = featureData)
names(assays(se)) <- c("nofill", "fill")

## Correct drift for single batch
se <- se[, colData(se)$batch == "F"]
se <- correctDrift(se, 
  injections = "inj", sampleGroups = "grp", RefID = "Ref", 
  G = seq(5, 35, by = 3), modelNames = c("VVE", "VEE"),
  report = FALSE, assay.type = "fill", name = "corrected")

}
