% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignBatches.R
\name{alignBatches}
\alias{alignBatches}
\alias{alignBatches,ANY,ANY-method}
\alias{alignBatches,SummarizedExperiment,SummarizedExperiment-method}
\title{Between-batch alignment of features}
\usage{
alignBatches(PeakTabNoFill, PeakTabFilled, ...)

\S4method{alignBatches}{ANY,ANY}(
  peakInfo,
  PeakTabNoFill,
  PeakTabFilled,
  batches,
  sampleGroups,
  selectGroup = "QC",
  NAhard = 0.8,
  mzdiff = 0.002,
  rtdiff = 15,
  report = TRUE,
  reportPath = NULL
)

\S4method{alignBatches}{SummarizedExperiment,SummarizedExperiment}(
  PeakTabNoFill,
  PeakTabFilled,
  batches,
  sampleGroups,
  assay.type1 = NULL,
  assay.type2 = NULL,
  name = NULL,
  mz_col = "mz",
  rt_col = "rt",
  ...
)
}
\arguments{
\item{PeakTabNoFill}{SummarizedExperiment object or matrix before gap-filling}

\item{PeakTabFilled}{SummarizedExperiment object or matrix without missing 
values}

\item{...}{parameters with same behavior across methods}

\item{peakInfo}{matrix with mz and rt in columns 1:2 (see e.g. ?peakInfo)}

\item{batches}{character scalar or factor, batch labels}

\item{sampleGroups}{character scalar or character, group labels}

\item{selectGroup}{character scalar, identifier of QC samples}

\item{NAhard}{numeric scalar, proportion of NAs within batch for feature to 
be considered missing}

\item{mzdiff}{numeric scalar, tolerance for difference in m/z}

\item{rtdiff}{numeric scalar, tolerance for difference in retention time}

\item{report}{boolean, whether to export diagnostic plots into your work 
directory (default: TRUE)}

\item{reportPath}{character scalar, directory path for report}

\item{assay.type1}{character scalar, assay of PeakTabNoFill to be used in 
case of multiple assays}

\item{assay.type2}{character scalar, assay of PeakTabFilled to be used in
case of multiple assays}

\item{name}{character scalar, name of the resultant assay in case of 
multiple assays}

\item{mz_col}{character scalar, name of column containing mass information}

\item{rt_col}{character scalar, name of column for retention time}
}
\value{
a SummarizedExperiment object as PeakTabFill with the aligned 
matrix or a list of six:
\itemize{
  \item PTalign: the aligned peak table
  \item boolAveragedAlign: boolean vector of final features where alignment 
    has been made using feature averaging
  \item PTfill: peaktable without missing values (indata)
  \item boolKeep: boolean vector of features kept after alignment
  \item boolAveragedFill boolean vector of original features where alignment 
    has been made using feature averaging
  \item aI: alignIndex object (indata)
}
}
\description{
Multi-batch alignment of features artificially split between batches.
}
\details{
A basic method with matrices (samples as rows) and SummarizedExperiment is 
supported. For grouping variables such as batches, the basic method expects 
vectors, while the SummarizedExperiment method expects the names of the 
respective columns in PeakTabFilled. The basic method returns a list with 
the aligned peak table and information about the process, whereas the 
SummarizedExperiment method assigns the aligned peak table to the object 
supplied to PeakTabFilled.
}
\examples{
data("ThreeBatchData")
# Basic method
## Extract peakinfo (i.e. m/z and rt of features).
peakIn <- peakInfo(PT = PTnofill, sep = "@", start = 3)
## Perform multi-batch alignment
alignBat <- alignBatches(
    peakInfo = peakIn, PeakTabNoFill = PTnofill,
    PeakTabFilled = PTfill, batches = meta$batch,
    sampleGroups = meta$grp, selectGroup = "QC",
    report = FALSE
)
## Extract new peak table
PT <- alignBat$PTalign

# SummarizedExperiment
## Construct SummarizedExperiment
peaks <- SimpleList(t(PTnofill), t(PTfill))
sampleData <- meta
featureData <- peakInfo(PT = PTnofill, sep = "@", start = 3)
rownames(featureData) <- rownames(peaks[[1]])
se <- SummarizedExperiment(assays = peaks, colData = sampleData, 
                           rowData = featureData)
names(assays(se)) <- c("nofill", "fill")

se <- alignBatches(PeakTabNoFill = se, PeakTabFilled = se,
                   batches = "batch", sampleGroups = "grp", report = FALSE,
                   assay.type1 = "nofill", assay.type2 = "fill", 
                   name = "aligned", rt_col = "rt", mz_col = "mz")
}
