% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listPackages.R
\name{listPackages}
\alias{listPackages}
\alias{listPythonVersion}
\title{List packages}
\usage{
listPackages(env)

listPythonVersion(env)
}
\arguments{
\item{env}{A \linkS4class{BasiliskEnvironment} object specifying the \pkg{basilisk} environment to use.

Alternatively, a string specifying the path to an environment, though this should only be used for testing purposes.}
}
\value{
For \code{listPackages}, a data.frame containing the \code{full}, a versioned package string, and \code{package}, the package name.

For \code{listPythonVersion}, a string containing the default version of Python.
}
\description{
List the set of Python packages (and their version numbers) that are installed in a virtual environment.
}
\examples{
tmploc <- file.path(tempdir(), "my_package_A")
if (!file.exists(tmploc)) {
    setupBasiliskEnv(tmploc, c('pandas=1.4.3'))
}
listPackages(tmploc)
listPythonVersion(tmploc)

}
\author{
Aaron Lun
}
