% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\docType{methods}
\name{makeFQTable}
\alias{makeFQTable}
\title{Generate an HTML table linking to per sample summary fastq QC statistics from ShortRead}
\usage{
makeFQTable(object, output = "static")
}
\arguments{
\item{object}{A basecall QC object as returned from basecallQC function}

\item{output}{Whether the report contains frozen or sortable tables. Options are "static" and "html"}
}
\value{
A HTML table for reporting fastq QC results from ShortRead. 
Table contains read counts and links to ShortRead QA reports per sample.
}
\description{
Creates an HTML table linking to per sample summary fastq QC statistics from ShortRead
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
bclQC <- basecallQC(bcl2fastqparams,RunMetaData=NULL,sampleSheet)
#makeFQTable(bclQC,output="static")
}
\author{
Thomas Carroll
}
